---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Sparse Field (classification)

> Under‑sampled or under‑resolved regime in which differences fall below ε and fail to register.

---

## Definition

- Sampling/resolution too low; many signals are sub‑ε
- Interfaces present but cannot accumulate enough evidence for closure
- Pattern recognition fails due to insufficient data

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Sparsity | Low density | `Sample`, `Count` |
| Resolution | Detail level | `Measure`, `Scale` |
| Evidence | Data points | `Collect`, `Test` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Sparsity | Too thin | "Not enough there" |
| Resolution | Detail loss | "Can't make it out" |
| Evidence | Weak signal | "Barely noticeable" |

### Crosswalk (bridge)

| Technical term | Humane term | Diagnostic meaning |
|---------------|-------------|-------------------|
| Low density | Too thin | What's missing |
| Detail level | Clarity | What we can see |
| Data points | Signals | What we can use |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Under-sampling | Weak signal |
| Networks | Sparse data | Thin connection |
| Cognition | Memory gaps | Faint impression |
| Systems | Missing points | Weak pattern |

---

## Scale Effects

How Sparse Field manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Sub-quantum | Wave loss |
| λV | Gate miss | State gap |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase gap | Pattern miss |
| ∇S | Structure loss | Boundary gap |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Causal gap | Light loss |
| λV | Field sparsity | Void dominance |

Note: At extreme scales, sparsity can become indistinguishable from fundamental limits (e.g., quantum uncertainty at ε, cosmic voids at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: resolution below phenomenon scale
- λV: gating too strict for signals
- ψA: windows too short for binding
- ∇S: structure detection fails

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Structure loss | Lost pattern |
| Human | λV | Gate miss | Missed signal |
| Cosmic | ψA | Phase gap | Lost binding |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Sub-ε | Signal loss | Too faint |
| Human | Under-sample | Data gaps | Missing pieces |
| Cosmic | Phase fail | No binding | No coherence |

---

## Diagnostic Checklist

Technical tests:
- [ ] Increase resolution/sampling
- [ ] Relax λV gates briefly
- [ ] Extend ψA window
- [ ] Check data density

Humane tests:
- [ ] Look more closely
- [ ] Open awareness
- [ ] Give more time
- [ ] Feel for patterns

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical sampling metrics nor experiential faintness alone captures its full meaning.

---

## See Also

- [[Transparent Field (classification)]]
- [[Masked Field (classification)]]
- [[Saturated Field (classification)]]
- [[Field]]
- [[Void]]
- [[Resolution Margin (diagnostic)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented